<?php

namespace StInMaWi\Controller\Admin;

use PDOException;
use StInMaWi\Controller\AbstractController;

/** @package StInMaWi\Controller\Admin */
class AdminSettingsController extends AbstractController
{
    public function general()
    {
        $settings = $this -> pagesRepository -> getAllGeneral();
        $this -> renderAdmin('pages/general', [
            'settings' => $settings
        ]);
    }

    public function createGeneral()
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $isAdminEMail = @(string) bulletProof(($_POST['isAdminEMail'] ?? ''));
            $lblIsBlog = @(string) bulletProof(($_POST['lblIsBlog'] ?? ''));
            $isRegister = @(string) bulletProof(($_POST['isRegister'] ?? ''));
            $IsUseMail = @(string) bulletProof(($_POST['isUseMail'] ?? ''));

            if(!empty($isAdminEMail))
            {
                $success = $this -> pagesRepository -> createPage($isAdminEMail, $lblIsBlog, $isRegister, $IsUseMail);
                if($success)
                {
                    header('Location: ./?route=admin/settings/general');
                    return;
                }
                else
                {
                    $errorMessage = 'Die Seite konnte nicht angelegt werden..., evtl. exisiert der Slug schon...';   
                }
            }
            else
            {
                $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...';
            }

            $this -> renderAdmin('pages/general', [
                'errorMessage' => $errorMessage
            ]);
        }
        else
        {
            $this -> renderAdmin('pages/general', []);
        }
    }

    public function updateGeneral($id)
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $id = @(int) ($_POST['settingId'] ?? 0);
            $title = @(int) ($_POST['title'] ?? 0);
            $subTitle = @(int) ($_POST['subTitle'] ?? 0);
            $sitetitle = @(int) ($_POST['sitetitle'] ?? 0);
            $isBlog = @(string) ($_POST['lblIsBlog'] ?? '');
            $isRegister = @(string) ($_POST['isRegister'] ?? '');
            $isAdminMail = @(string) ($_POST['isAdminMail'] ?? '');
            $isUseMail = @(string) ($_POST['isUseMail'] ?? '');
            $isCookieBanner = @(string) ($_POST['isCookieBanner'] ?? '');

            if(!empty($title) && !empty($content))
            {
                $this -> pagesRepository -> updateGeneral($id, $title, $subTitle, $sitetitle, $isBlog, $isRegister, $isAdminMail, $isUseMail, $isCookieBanner);
                header('Location: ./?route=admin/settings/general');
                return;
            }
            else
            {
                $page = $this -> pagesRepository -> findSettingsById($id);
                $this -> renderAdmin('pages/general', [
                    'page' => $page,
                    'errorMessage' => $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...'
                ]);
            }         
        }
        else
        {
            $page = $this -> pagesRepository -> findSettingsById($id);
            $this -> renderAdmin('pages/general', [
                'page' => $page
            ]);
        }
    }

    public function menu()
    {
        $pages = $this -> pagesRepository-> getAllPages();
        $this -> renderAdmin('pages/menu', [
            'pages' => $pages
        ]);
    }

    public function createMenu()
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $title = @(string) ($_POST['pageTitle'] ?? '');
            $slug = @(string) ($_POST['pageSlug'] ?? '');
            $content = @(string) ($_POST['pageContent'] ?? '');

            if(empty($slug))
            {
                $preSlug = str_replace(' ', '-', $title);
                $slug = strtolower($preSlug);
            }

            if(!empty($title) && !empty($slug) && !empty($content))
            {
                $success = $this ->pagesRepository ->createPage($title, $slug, $content);
                if($success)
                {
                    header('Location: ./?route=admin/pages');
                    return;
                }
                else
                {
                    $errorMessage = 'Die Seite konnte nicht angelegt werden..., evtl. exisiert der Slug schon...';   
                }
            }
            else
            {
                $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...';
            }

            $this -> renderAdmin('pages/create-page', [
                'errorMessage' => $errorMessage
            ]);
        }
        else
        {
            $this -> renderAdmin('pages/create-page', []);
        }
    }

    public function updateMenu($id)
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $id = @(int) ($_POST['pageId'] ?? 0);
            $title = @(string) ($_POST['pageTitle'] ?? '');
            $content = @(string) ($_POST['pageContent'] ?? '');

            if(!empty($title) && !empty($content))
            {
                $this ->pagesRepository->updatePage($id, $title, $content);
                header('Location: ./?route=admin/pages');
                return;
            }
            
            $page = $this -> pagesRepository -> findMenuById($id);
            $this -> renderAdmin('pages/edit-page', [
                'page' => $page,
                'errorMessage' => $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...'
            ]);         
        }
        else
        {
            $page = $this -> pagesRepository -> findMenuById($id);
            $this -> renderAdmin('pages/edit-page', [
                'page' => $page
            ]);
        }
    }

    public function design()
    {
        $designs = $this -> pagesRepository->getAllPages();
        $this -> renderAdmin('pages/design', [
            'designs' => $designs
        ]);
    }

    public function createDesign()
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $title = @(string) ($_POST['pageTitle'] ?? '');
            $slug = @(string) ($_POST['pageSlug'] ?? '');
            $content = @(string) ($_POST['pageContent'] ?? '');

            if(empty($slug))
            {
                $preSlug = str_replace(' ', '-', $title);
                $slug = strtolower($preSlug);
            }

            if(!empty($title) && !empty($slug) && !empty($content))
            {
                $success = $this ->pagesRepository ->createPage($title, $slug, $content);
                if($success)
                {
                    header('Location: ./?route=admin/pages');
                    return;
                }
                else
                {
                    $errorMessage = 'Die Seite konnte nicht angelegt werden..., evtl. exisiert der Slug schon...';   
                }
            }
            else
            {
                $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...';
            }

            $this -> renderAdmin('pages/create-page', [
                'errorMessage' => $errorMessage
            ]);
        }
        else
        {
            $this -> renderAdmin('pages/create-page', []);
        }
    }

    public function updateDesign($id)
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $id = @(int) ($_POST['pageId'] ?? 0);
            $title = @(string) ($_POST['pageTitle'] ?? '');
            $content = @(string) ($_POST['pageContent'] ?? '');

            if(!empty($title) && !empty($content))
            {
                $this ->pagesRepository->updatePage($id, $title, $content);
                header('Location: ./?route=admin/pages');
                return;
            }
            
            $page = $this -> pagesRepository -> findDesignById($id);
            $this -> renderAdmin('pages/edit-page', [
                'page' => $page,
                'errorMessage' => $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...'
            ]);         
        }
        else
        {
            $page = $this -> pagesRepository -> findDesignById($id);
            $this -> renderAdmin('pages/edit-page', [
                'page' => $page
            ]);
        }
    }

    public function shop()
    {
        $pages = $this -> pagesRepository->getShopPage();
        $this -> renderAdmin('pages/online-shop', [
            'pages' => $pages
        ]);
    }

    public function createShop()
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $title = @(string) ($_POST['pageTitle'] ?? '');
            $slug = @(string) ($_POST['pageSlug'] ?? '');
            $content = @(string) ($_POST['pageContent'] ?? '');

            if(empty($slug))
            {
                $preSlug = str_replace(' ', '-', $title);
                $slug = strtolower($preSlug);
            }

            if(!empty($title) && !empty($slug) && !empty($content))
            {
                $success = $this -> pagesRepository -> createPage($title, $slug, $content);
                if($success)
                {
                    header('Location: ./?route=admin/pages');
                    return;
                }
                else
                {
                    $errorMessage = 'Die Seite konnte nicht angelegt werden..., evtl. exisiert der Slug schon...';   
                }
            }
            else
            {
                $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...';
            }

            $this -> renderAdmin('pages/create-page', [
                'errorMessage' => $errorMessage
            ]);
        }
        else
        {
            $this -> renderAdmin('pages/create-page', []);
        }
    }

    public function updateShop($id)
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $id = @(int) ($_POST['pageId'] ?? 0);
            $title = @(string) ($_POST['pageTitle'] ?? '');
            $content = @(string) ($_POST['pageContent'] ?? '');

            if(!empty($title) && !empty($content))
            {
                $this ->pagesRepository->updatePage($id, $title, $content);
                header('Location: ./?route=admin/pages');
                return;
            }
            
            $page = $this -> pagesRepository -> findShopById($id);
            $this -> renderAdmin('pages/edit-page', [
                'page' => $page,
                'errorMessage' => $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...'
            ]);         
        }
        else
        {
            $page = $this -> pagesRepository -> findShopById($id);
            $this -> renderAdmin('pages/edit-page', [
                'page' => $page
            ]);
        }
    }
    
    public function extensions()
    {
        // Shop-System
        $file_controller = 'src/Controller/AdminShopController.php';
        $directory = 'src/Shop/';
        $file_shop = '';
        $file_repository = '';
        if(file_exists($directory))
        {
            
        }
        else
        {
            
        }

        $extensions = $this -> pagesRepository -> getAllExtensions();
        $this -> renderAdmin('pages/extensions', [
            'extensions' => $extensions
        ]);
    }
}