<?php

namespace StInMaWi\Controller\Admin;

use PDOException;
use StInMaWi\Controller\AbstractController;
use ZipArchive;

/** @package StInMaWi\Controller\Admin */
class AdminPagesController extends AbstractController
{
    /**
     * @return void 
     * @throws PDOException 
     */
    public function index()
    {
        if(isset($_POST['search_updates']))
        {
            $errorMessage = null;
            $file_url = 'https://update.your-cms.de/cms-update.zip';
            $file_path = 'admin/downloads/downloaded_update.zip';
            $zip_resource = fopen($file_path, 'w');
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $file_url);
            curl_setopt($ch, CURLOPT_FAILONERROR, true);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_FILE, $zip_resource);
            $url = curl_exec($ch);

            if(!$url)
            {
                $errorMessage = 'Error: ' . curl_error($ch);
            }
            
            curl_close($ch);
            
            $zip = new ZipArchive;
            $extractPath = 'admin/updates/';
            if($zip -> open($file_path, ZipArchive::CREATE || ZipArchive::OVERWRITE) !== true)
            {
                $errorMessage = 'Error: Unable to open the Zip File';
            } 
            
            $zip -> extractTo($extractPath);
            $zip -> close();
            
            header('Location: ./?route=admin/index');
        }
        else
        {
            $pages = $this -> pagesRepository -> getAllPages();
            $this -> renderAdmin('pages/index', [
                'pages' => $pages
            ]);
        }
    }

    public function extensions()
    {
        $extensions = $this -> pagesRepository -> getAllPages();
        $this -> renderAdmin('pages/index', [
            'extensions' => $extensions
        ]);
    }

    public function pages()
    {
        $pages = $this -> pagesRepository->getAllPages();
        $this -> renderAdmin('pages/pages', [
            'pages' => $pages
        ]);
    }

    public function createPage()
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $title = @(string) ($_POST['title']);
            $slug = @(string) ($_POST['slug'] );
            $content = @(string) ($_POST['content']);

            if(empty($slug))
            {
                $preSlug = str_replace(' ', '-', $title);
                $slug = strtolower($preSlug);
            }

            if(!empty($title))
            {
                $success = $this -> pagesRepository -> createPage($title, $slug, $content);
                if($success)
                {
                    header('Location: ./?route=admin/pages');
                    return;
                }
                else
                {
                    $errorMessage = 'Die Seite konnte nicht angelegt werden..., evtl. exisiert der Slug schon...';   
                }
            }
            else
            {
                $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...';
            }

            $this -> renderAdmin('pages/create-page', [
                'errorMessage' => $errorMessage
            ]);
        }
        else
        {
            $this -> renderAdmin('pages/create-page', []);
        }
    }

    public function editPage($id)
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $id = @(int) ($_POST['id'] ?? 0);
            $title = @(string) ($_POST['title'] ?? '');
            $content = @(string) ($_POST['content'] ?? '');

            if(!empty($title) && !empty($content))
            {
                $this -> pagesRepository -> updatePage($id, $title, $content);
                header('Location: ./?route=admin/pages');
                return;
            }
            
            $page = $this -> pagesRepository -> findPageById($id);
            $this -> renderAdmin('pages/edit-page', [
                'page' => $page,
                'errorMessage' => $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...'
            ]);         
        }
        else
        {
            $page = $this -> pagesRepository -> findPageById($id);
            $this -> renderAdmin('pages/edit-page', [
                'page' => $page
            ]);
        }
    }

    /**
     * @param mixed $id 
     * @return void 
     * @throws PDOException 
     */
    public function deletePage($id)
    {
        $pages = $this -> pagesRepository -> deletePage($id);
        header('Location: ./?route=admin/pages');
    }
}