<?php
namespace StInMaWi\Controller;

use PDOException;
use StInMaWi\Posts\PostsRepository;

/** @package StInMaWi\Controller */
abstract class AbstractPostsController
{
    /**
     * @param PostsRepository $postsRepository 
     * @return void 
     */
    public function __construct(protected PostsRepository $postsRepository) { }

    /**
     * @return void 
     * @throws PDOException 
     */
    protected function showError404()
    {
        http_response_code(404);
        $this -> render("abstract/showError404", []);
    }

    protected function showAccessDenied401()
    {
        http_response_code(401);
        $this -> render("abstract/showAccessDenied401", []);
    }

    /**
     * @param mixed $path 
     * @param array $data 
     * @return void 
     * @throws PDOException 
     */
    protected function render($path, array $data = [])
    {
        ob_start();
        extract($data);
        require __DIR__ . '/../../views/frontend/' . $path . '.view.php';
        $content = ob_get_contents();
        ob_end_clean();

        $posts = $this -> postsRepository -> getPosts();

        require __DIR__ . '/../../views/frontend/layouts/main/main.view.php';
    }

    /**
     * @param mixed $path 
     * @param array $data 
     * @return void 
     */
    protected function renderAdmin($path, array $data = [])
    {
        ob_start();
        extract($data);
        require __DIR__ . '/../../views/admin/' . $path . '.view.php';
        $content = ob_get_contents();
        ob_end_clean();
        
        require __DIR__ . '/../../views/admin/layouts/main/main.view.php';
    }

} 