<?php

namespace StInMaWi\Controller;

use PDOException;
use StInMaWi\Posts\PostsRepository;

/** @package StInMaWi\Controller */
class PostsController extends AbstractPostsController
{
    /**
     * @param PostsRepository $postsRepository 
     * @return void 
     */
    public function __construct(PostsRepository $postsRepository)
    {
        parent::__construct($postsRepository);
    }

    /**
     * @param string $postKey 
     * @return void 
     * @throws PDOException 
     */
    public function showPosts(string $postKey)
    {
        $posts = $this -> postsRepository -> getPosts($postKey);
        if(empty($posts))
        {
            return $this -> showError404();
        }

        $this -> render('posts/showPost', [
            'posts' => $posts
        ]);
    }
}