<?php

namespace StInMaWi\Controller\Admin;

use PDOException;
use StInMaWi\Controller\AbstractController;

/** @package StInMaWi\Controller\Admin */
class AdminUsersController extends AbstractController
{
    public function users()
    {
        $pages = $this -> pagesRepository -> getUsers();
        $this -> renderAdmin('pages/users', [
            'pages' => $pages
        ]);
    }

    public function createUser()
    {
        if(!empty($_POST))
        {
            $currentUser = $_SESSION['loginUser'];
            $errorMessage = null;
            $username = @(string) ($_POST['userNmae'] ?? '');
            $password = @(string) ($_POST['password'] ?? '');
            $email = @(string) ($_POST['eMailAddress'] ?? '');
            $type = @(string) ($_POST['type'] ?? '');
            $addedDate = date('d-M-Y H:i:s');
            $addedBy = $currentUser;

            if(!empty($username) && !empty($password))
            {
                $success = $this -> pagesRepository -> createUser($username, $password, $email, $type, $addedDate, $addedBy);
                if($success)
                {
                    header('Location: ./?route=admin/users');
                    return;
                }
                else
                {
                    $errorMessage = 'Die Seite konnte nicht angelegt werden..., evtl. exisiert der Slug schon...';   
                }
            }
            else
            {
                $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...';
            }

            $this -> renderAdmin('pages/create-user', [
                'errorMessage' => $errorMessage
            ]);
        }
        else
        {
            $this -> renderAdmin('pages/create-user', []);
        }
    }

    /**
     * @param mixed $id 
     * @return void 
     * @throws PDOException 
     */
    public function editUser($id)
    {
        if(!empty($_POST))
        {
            $currentUser = $_SESSION['loginUser'];
            $errorMessage = null;
            $id = @(int) ($_POST['id'] ?? 0);
            $username = @(string) ($_POST['username'] ?? '');
            $email = @(string) ($_POST['email'] ?? '');
            $type = @(string) ($_POST['type'] ?? '');
            $modifiedDate = date('d-M-Y H:i:s');
            $modifiedBy = $currentUser;

            if(!empty($username) && !empty($password))
            {
                $this -> pagesRepository -> updateUser($id, $username, $password, $email, $type, $modifiedDate, $modifiedBy);
                header('Location: ./?route=admin/users');
                return;
            }
            
            $page = $this -> pagesRepository -> findUserById($id);
            $this -> renderAdmin('pages/edit-user', [
                'page' => $page,
                'errorMessage' => $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...'
            ]);         
        }
        else if(isset($_POST['btnChangePassword']))
        {
            $currentUser = $_SESSION['loginUser'];
            $errorMessage = null;
            $id = @(int) ($_POST['id'] ?? 0);
            $username = @(string) ($_POST['username'] ?? '');
            $password = @(string) password_hash(($_POST['password']), PASSWORD_DEFAULT);
            $email = @(string) ($_POST['email'] ?? '');
            $type = @(string) ($_POST['type'] ?? '');
            $modifiedDate = date('d-M-Y H:i:s');
            $modifiedBy = $currentUser;
            if(!empty($password))
            {
                $this -> pagesRepository -> updateUser($id, $username, $password, $email, $type, $modifiedDate, $modifiedBy);
                header('Location: ./?route=admin/users');
                return;
            }
        }
        else
        {
            $page = $this -> pagesRepository -> findUserById($id);
            $this -> renderAdmin('pages/edit-user', [
                'page' => $page
            ]);
        }
    }

    /**
     * @param mixed $id 
     * @return void 
     * @throws PDOException 
     */
    public function deleteUser($id)
    {
        $pages = $this -> pagesRepository -> deleteUser($id);
        header('Location: ./?route=admin/users');
    }
}