<?php

namespace StInMaWi\Controller\Admin;

use PDOException;
use StInMaWi\Controller\AbstractController;

/** @package StInMaWi\Controller\Admin */
class AdminPostsController extends AbstractController
{
    public function posts()
    {
        $posts = $this -> pagesRepository -> getAllPosts();
        $this -> renderAdmin('posts/posts', [
            'posts' => $posts
        ]);
    }

    public function createPost()
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $title = @(string) ($_POST['postTitle'] ?? '');
            $slug = @(string) ($_POST['postSlug'] ?? '');
            $content = @(string) ($_POST['postContent'] ?? '');

            if(empty($slug))
            {
                $preSlug = str_replace(' ', '-', $title);
                $slug = strtolower($preSlug);
            }

            if(!empty($title) && !empty($slug) && !empty($content))
            {
                $success = $this ->pagesRepository -> createPost($title, $slug, $content);
                if($success)
                {
                    header('Location: ./?route=admin/posts');
                    return;
                }
                else
                {
                    $errorMessage = 'Die Seite konnte nicht angelegt werden..., evtl. exisiert der Slug schon...';   
                }
            }
            else
            {
                $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...';
            }

            $this -> renderAdmin('posts/create-post', [
                'errorMessage' => $errorMessage
            ]);
        }
        else
        {
            $this -> renderAdmin('posts/create-post', []);
        }
    }

    public function editPost($id)
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $id = @(int) ($_POST['postId'] ?? 0);
            $title = @(string) ($_POST['postTitle'] ?? '');
            $content = @(string) ($_POST['postContent'] ?? '');

            if(!empty($title) && !empty($content))
            {
                $this -> pagesRepository -> updatePost($id, $title, $content);
                header('Location: ./?route=admin/posts');
                return;
            }
            
            $post = $this -> pagesRepository -> findPostById($id);
            $this -> renderAdmin('posts/edit-post', [
                'post' => $post,
                'errorMessage' => $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...'
            ]);         
        }
        else
        {
            $post = $this -> pagesRepository -> findPostById($id);
            $this -> renderAdmin('posts/edit-post', [
                'post' => $post
            ]);
        }
    }

    public function deletePost($id)
    {
        $posts = $this -> pagesRepository -> deletePost($id);
        header('Location: ./?route=admin/posts');
    }
}